<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>اطلاعات محصول ترب با کوکی</title>
  <style>
    body { font-family: sans-serif; direction: rtl; background: #f5f5f5; padding: 40px; }
    form { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px #ccc; max-width: 600px; margin: auto; }
    input[type=text] { width: 100%; padding: 10px; margin-bottom: 15px; border-radius: 5px; border: 1px solid #ddd; }
    button { padding: 10px 20px; background: #00b894; color: white; border: none; border-radius: 5px; cursor: pointer; }
    .product { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px #ccc; max-width: 800px; margin: 30px auto; }
    .product img { max-width: 150px; display: block; margin-bottom: 10px; }
    .specs { background: #f9f9f9; padding: 10px; margin-top: 15px; border-radius: 5px; }
    .specs ul { list-style: none; padding: 0; }
    .specs li { margin-bottom: 5px; }
    .error { color: red; text-align: center; }
  </style>
</head>
<body>

<form method="get">
  <label>لینک محصول ترب را وارد کنید:</label>
  <input type="text" name="url" placeholder="https://torob.com/p/..." required>
  <button type="submit">نمایش اطلاعات</button>
</form>

<?php
if (isset($_GET['url']) && strpos($_GET['url'], '/p/') !== false) {
    $url = $_GET['url'];
    preg_match('/\/p\/([a-z0-9\-]+)/i', $url, $match);
    $product_id = $match[1] ?? '';

    if ($product_id) {
        $pageUrl = "https://torob.com/p/" . $product_id . "/";
        $ch = curl_init($pageUrl);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_TIMEOUT => 15,
            CURLOPT_HTTPHEADER => [
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
                "Referer: https://torob.com/",
                "Cookie: torob_token=🔑اینجا-توکن-کوکی-خودتو-بذار;"
            ]
        ]);
        $html = curl_exec($ch);
        curl_close($ch);

        if (preg_match('/<script id="__NEXT_DATA__" type="application\/json">(.*?)<\/script>/s', $html, $matches)) {
            $json = json_decode($matches[1], true);
            $product = $json['props']['pageProps']['product'] ?? null;
            $offers = $json['props']['pageProps']['offers'] ?? [];

            if ($product) {
                echo "<div class='product'>";
                echo "<h2>" . htmlspecialchars($product['title']) . "</h2>";
                echo "<img src='" . htmlspecialchars($product['image_url']) . "' alt='product image'>";
                echo "<p>قیمت از " . number_format($product['min_price']) . " تا " . number_format($product['max_price']) . " تومان</p>";

                echo "<div class='specs'><strong>مشخصات فنی:</strong><ul>";
                foreach ($product['specifications'] ?? [] as $spec) {
                    echo "<li>" . htmlspecialchars($spec['key']) . ": " . htmlspecialchars($spec['value']) . "</li>";
                }
                echo "</ul></div>";

                if (!empty($offers)) {
                    echo "<div class='specs'><strong>فروشندگان:</strong><ul>";
                    foreach ($offers as $offer) {
                        echo "<li>" . htmlspecialchars($offer['seller_name']) . " - " . number_format($offer['price']) . " تومان (" . $offer['delivery_text'] . ")</li>";
                    }
                    echo "</ul></div>";
                }

                echo "</div>";
            } else {
                echo "<p class='error'>محصول یافت نشد.</p>";
            }
        } else {
            echo "<p class='error'>عدم توانایی در خواندن داده‌های JSON از صفحه.</p>";
        }
    } else {
        echo "<p class='error'>شناسه محصول در لینک یافت نشد.</p>";
    }
}
?>

</body>
</html>
