<?php
header('Content-Type: application/json');

if (!isset($_GET['url'])) {
    echo json_encode(['error' => 'URL دسته‌بندی الزامی است']);
    exit;
}

$baseUrl = $_GET['url'];
$totalPages = isset($_GET['pages']) ? intval($_GET['pages']) : 1; // تعداد صفحات ورودی
$page = 1;
$products = [];

while ($page <= $totalPages) {
    // اضافه کردن پارامتر only_available
    $url = $baseUrl . (strpos($baseUrl, '?') === false ? '?' : '&') . 'only_available=true&page=' . $page;
    $html = file_get_contents($url);
    if (!$html) break;

    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    libxml_clear_errors();

    $xpath = new DOMXPath($dom);
    $foundProducts = false;

    foreach ($xpath->query("//section[contains(@class,'bg-white')]//a[@href]") as $link) {
        $name = trim($link->textContent);
        $href = $link->getAttribute('href');

        if (strpos($href, 'product-') !== false) {
            $products[] = [
                'name' => $name,
                'link' => 'https://www.technolife.com' . $href
            ];
            $foundProducts = true;
        }
    }

    if (!$foundProducts) break;
    $page++;
}

echo json_encode($products, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);