<?php

header('Content-Type: application/json; charset=utf-8');

// گرفتن لینک از GET
$url = isset($_GET['url']) ? $_GET['url'] : '';

if (empty($url) || !preg_match('/product-(\d+)/', $url, $matches)) {
    echo json_encode(['error' => 'لینک نامعتبر است یا شناسه محصول یافت نشد.']);
    exit;
}

$productId = $matches[1];
$productPage = "https://www.technolife.com/product-$productId";

function curlRequest($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTPHEADER => [
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 Chrome/134.0.0.0 Safari/537.36',
            'Accept: text/html'
        ]
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        $err = curl_error($ch);
        curl_close($ch);
        return ['error' => $err];
    }
    curl_close($ch);
    return $response;
}

// مرحله اول: گرفتن HTML صفحه
$html = curlRequest($productPage);
if (isset($html['error'])) {
    echo json_encode($html, JSON_UNESCAPED_UNICODE);
    exit;
}

// مرحله دوم: استخراج JSON از NEXT_DATA
preg_match('/<script id="__NEXT_DATA__" type="application\/json">(.*?)<\/script>/s', $html, $matches);
if (!isset($matches[1])) {
    echo json_encode(['error' => 'اطلاعات محصول یافت نشد.']);
    exit;
}

$jsonData = json_decode($matches[1], true);

// مسیر دقیق اطلاعات محصول در ساختار React/Next.js
$data = $jsonData['props']['pageProps']['dehydratedState']['queries'][0]['state']['data'] ?? null;
if (!$data) {
    echo json_encode(['error' => 'داده‌ای یافت نشد.']);
    exit;
}

// آماده‌سازی خروجی
$output = [
    'id' => $productId,
    'title' => $data['title_fa'] ?? '',
    'price' => $data['price'] ?? 0,
    'images' => $data['product_gallery'] ?? [],
    'description' => strip_tags(html_entity_decode($data['product_review'] ?? '')),
    'specifications' => $data['product_info'] ?? [],
];

echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);