<?php
class StateStore {
    private $file;

    public function __construct($file) {
        $this->file = $file;
        if (!file_exists($file)) {
            file_put_contents($file, json_encode([], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        }
    }

    private function readAll() {
        $raw = @file_get_contents($this->file);
        if (!$raw) return [];
        $data = json_decode($raw, true);
        return is_array($data) ? $data : [];
    }

    private function writeAll($data) {
        file_put_contents($this->file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }

    public function get($chatId) {
        $all = $this->readAll();
        return isset($all[$chatId]) && is_array($all[$chatId]) ? $all[$chatId] : [];
    }

    public function set($chatId, array $state) {
        $all = $this->readAll();
        $all[$chatId] = $state;
        $this->writeAll($all);
    }

    public function clear($chatId) {
        $all = $this->readAll();
        unset($all[$chatId]);
        $this->writeAll($all);
    }
}
