<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>نمایش اطلاعات محصول باسلام</title>
  <style>
    body { font-family: sans-serif; background: #f8f9fa; direction: rtl; padding: 40px; }
    .container { max-width: 800px; margin: auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px #ccc; }
    input[type=text] { width: 100%; padding: 12px; margin-bottom: 20px; border-radius: 6px; border: 1px solid #ccc; }
    button { background-color: #2d98da; color: white; padding: 12px 25px; border: none; border-radius: 6px; cursor: pointer; }
    .result { margin-top: 30px; }
    .result img { max-width: 200px; display: block; margin-bottom: 20px; }
    .result h2 { margin-bottom: 10px; }
    .result p { margin: 6px 0; }
    .images { display: flex; flex-wrap: wrap; gap: 10px; margin-top: 15px; }
    .images img { max-width: 100px; border: 1px solid #ddd; border-radius: 6px; }
  </style>
</head>
<body>
  <div class="container">
    <form method="get">
      <label for="url">لینک محصول باسلام:</label>
      <input type="text" name="url" id="url" placeholder="https://basalam.com/..." required>
      <button type="submit">نمایش اطلاعات</button>
    </form>

    <?php
    if (isset($_GET['url'])) {
        $apiUrl = 'https://majazi.top/basslam/shop.php?url=' . urlencode($_GET['url']);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($response, true);

        if (!$result || isset($result['error'])) {
            echo "<p style='color:red;'>⚠️ خطا: " . htmlspecialchars($result['error'] ?? 'خطای ناشناخته') . "</p>";
        } else {
            echo "<div class='result'>";
            echo "<h2>📦 " . htmlspecialchars($result['title'] ?? '---') . "</h2>";
            echo "<p><strong>💰 قیمت:</strong> " . number_format((int)($result['price'] ?? 0)) . " تومان</p>";
            echo "<p><strong>📂 دسته‌بندی:</strong> " . htmlspecialchars($result['breadcrumb'] ?? '---') . "</p>";
            echo "<p><strong>💬 توضیحات:</strong> " . htmlspecialchars($result['description'] ?? '---') . "</p>";

            if (!empty($result['all_image_preloads']) && is_array($result['all_image_preloads'])) {
                echo "<div class='images'>";
                foreach ($result['all_image_preloads'] as $img) {
                    echo "<img src='$img' loading='lazy'>";
                }
                echo "</div>";
            }

            echo "</div>";
        }
    }
    ?>
  </div>
</body>
</html>
