<?php
header('Content-Type: text/plain; charset=utf-8');

// فایل ورودی و خروجی
$proxyFile = __DIR__ . '/proxies.txt';
$aliveFile = __DIR__ . '/proxies_alive.txt';

if (!file_exists($proxyFile)) {
    die("❌ فایل proxies.txt یافت نشد.\n");
}

$proxies = file($proxyFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$total = count($proxies);

if ($total === 0) {
    die("⚠️ هیچ پراکسی در فایل نیست.\n");
}

echo "🔎 شروع تست $total پراکسی...\n";
$aliveProxies = [];

foreach ($proxies as $proxy) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => 'https://httpbin.org/ip',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_PROXY => $proxy,
        CURLOPT_TIMEOUT => 8,
        CURLOPT_CONNECTTIMEOUT => 5,
        CURLOPT_SSL_VERIFYHOST => 0,
        CURLOPT_SSL_VERIFYPEER => 0,
    ]);

    $response = curl_exec($ch);
    $error = curl_error($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200 && !$error && $response) {
        echo "✅ سالم: $proxy | پاسخ: $response\n";
        $aliveProxies[] = $proxy;
    } else {
        echo "❌ مرده: $proxy | خطا: $error\n";
    }
}

// ذخیره پراکسی‌های سالم
file_put_contents($aliveFile, implode(PHP_EOL, $aliveProxies));
echo "\n🔵 تست تمام شد. تعداد پراکسی سالم: " . count($aliveProxies) . "\n";
echo "📂 پراکسی‌های سالم در فایل proxies_alive.txt ذخیره شدند.\n";