<?php
header('Content-Type: application/json; charset=utf-8');

// اعتبارسنجی ورودی
if (!isset($_GET['url'])) {
    echo json_encode(['error' => 'لینک محصول مشخص نشده است'], JSON_UNESCAPED_UNICODE);
    exit;
}

$url = $_GET['url'];

// گرفتن HTML
$context = stream_context_create([
    "http" => [
        "header" => "User-Agent: Mozilla/5.0\r\n"
    ]
]);
$html = file_get_contents($url, false, $context);

if (!$html) {
    echo json_encode(['error' => 'عدم موفقیت در بارگیری صفحه'], JSON_UNESCAPED_UNICODE);
    exit;
}

$html = mb_convert_encoding($html, 'UTF-8', 'auto');

// استخراج تمام JSON-LD
preg_match_all('/<script type="application\/ld\+json">(.*?)<\/script>/is', $html, $matches);

// مقداردهی متغیرها
$product = null;
$categories = [];

// پیمایش اسکریپت‌ها
foreach ($matches[1] as $jsonRaw) {
    $jsonRaw = html_entity_decode($jsonRaw, ENT_QUOTES | ENT_HTML5);
    $jsonData = json_decode($jsonRaw, true);

    // استخراج اطلاعات محصول
    if (isset($jsonData["@graph"])) {
        foreach ($jsonData["@graph"] as $item) {
            if (($item["@type"] ?? '') === "Product") {
                $product = $item;
            }
        }
    } elseif (($jsonData["@type"] ?? '') === "Product") {
        $product = $jsonData;
    }

    // استخراج دسته‌بندی از breadcrumb
    if (($jsonData["@type"] ?? '') === "BreadcrumbList") {
        foreach ($jsonData["itemListElement"] ?? [] as $item) {
            if (isset($item["item"]["name"])) {
                $categories[] = $item["item"]["name"];
            }
        }
    }
}

// استخراج توضیح کامل از DOM
$doc = new DOMDocument();
libxml_use_internal_errors(true);
$doc->loadHTML($html);
libxml_clear_errors();
$xpath = new DOMXPath($doc);
$descNode = $xpath->query("//*[contains(@class, 'product-description')]")->item(0);
$fullDescription = $descNode ? trim($doc->saveHTML($descNode)) : '';

// خروجی نهایی
$output = [
    'title' => $product['name'] ?? '',
    'description_short' => strip_tags($product['description'] ?? ''),
    'description_full_html' => $fullDescription,
    'price' => $product['offers']['price'] ?? '',
    'currency' => $product['offers']['priceCurrency'] ?? '',
    'image' => $product['image'][0] ?? '',
    'rating' => $product['aggregateRating']['ratingValue'] ?? '',
    'categories' => $categories,
    'url' => $product['url'] ?? $url
];

echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);