<?php
// نمایش خطاها برای تست
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_GET['url']) || empty($_GET['url'])) {
    die(json_encode(['error' => 'لینک محصول وارد نشده است.']));
}

$url = $_GET['url'];

function getWooProductData($url) {
    // دریافت سورس صفحه
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $html = curl_exec($ch);
    curl_close($ch);

    if (!$html) {
        return json_encode(['error' => 'خطا در دریافت محتوا']);
    }

    // لود HTML
    $dom = new DOMDocument();
    @$dom->loadHTML($html);

    $xpath = new DOMXPath($dom);

    // عنوان محصول
    $title = $xpath->query('//h1[contains(@class,"product_title")]')->item(0)->textContent ?? '';

    // قیمت
    $price = $xpath->query('//p[contains(@class,"price")]//span')->item(0)->textContent ?? '';

    // توضیحات کوتاه
    $short_desc = '';
    $short_desc_node = $xpath->query('//div[contains(@class,"woocommerce-product-details__short-description")]')->item(0);
    if ($short_desc_node) {
        $short_desc = trim($short_desc_node->textContent);
    }

    // توضیحات کامل
    $full_desc = '';
    $full_desc_node = $xpath->query('//div[@id="tab-description"]')->item(0);
    if ($full_desc_node) {
        $full_desc = trim($full_desc_node->textContent);
    }

    // تصاویر محصول
    $images = [];
    foreach ($xpath->query('//figure[contains(@class,"woocommerce-product-gallery__wrapper")]//img') as $img) {
        $src = $img->getAttribute('src');
        if (!in_array($src, $images)) {
            $images[] = $src;
        }
    }

    // دسته‌بندی‌ها
    $categories = [];
    foreach ($xpath->query('//span[contains(@class,"posted_in")]/a') as $cat) {
        $categories[] = trim($cat->textContent);
    }

    // برچسب‌ها
    $tags = [];
    foreach ($xpath->query('//span[contains(@class,"tagged_as")]/a') as $tag) {
        $tags[] = trim($tag->textContent);
    }

    return [
        'title'       => trim($title),
        'price'       => trim($price),
        'short_desc'  => $short_desc,
        'full_desc'   => $full_desc,
        'images'      => $images,
        'categories'  => $categories,
        'tags'        => $tags,
        'url'         => $url
    ];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode(getWooProductData($url), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);