<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

header('Content-Type: application/json; charset=utf-8');

// ✅ بررسی پارامتر URL
if (!isset($_GET['url']) || empty($_GET['url'])) {
    echo json_encode(['error' => 'پارامتر URL الزامی است'], JSON_UNESCAPED_UNICODE);
    exit;
}

$apiKey = "00a6292ae8e72b7808d47ee9da4829a1";
$targetUrl = $_GET['url'];

// ساخت لینک ScraperAPI
$scraperUrl = "https://api.scraperapi.com?api_key={$apiKey}&url=" . urlencode($targetUrl);

$client = new Client([
    'headers' => [
        'User-Agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115 Safari/537.36',
        'Accept' => 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'Accept-Language' => 'fa,en;q=0.9'
    ],
    'verify' => false,
    'timeout' => 60,
]);

try {
    $response = $client->get($scraperUrl);
    $html = (string)$response->getBody();

    // ✅ استخراج JSON-LD محصول
    preg_match_all('/<script[^>]+type="application\/ld\+json"[^>]*>(.*?)<\/script>/is', $html, $matches);
    $productData = [];
    foreach ($matches[1] as $jsonData) {
        $json = json_decode($jsonData, true);
        if (isset($json['@type']) && strtolower($json['@type']) === 'product') {
            $productData = $json;
            break;
        }
    }

    $output = [
        'name'        => $productData['name'] ?? '',
        'alternateName' => $productData['alternateName'] ?? '',
        'description' => $productData['description'] ?? '',
        'brand'       => $productData['brand']['name'] ?? '',
        'image'       => $productData['image'] ?? '',
        'sku'         => $productData['sku'] ?? '',
        'url'         => $productData['url'] ?? '',
        'offers'      => []
    ];

    if (!empty($productData['offers']['offers'])) {
        foreach ($productData['offers']['offers'] as $offer) {
            $price = $offer['price'] ?? '';
            $output['offers'][] = [
                'shop_name'   => $offer['name'] ?? '',
                'price'       => $price ? number_format($price / 10) . ' تومان' : '',
                'price_raw'   => $price,
                'currency'    => $offer['priceCurrency'] ?? '',
                'availability'=> $offer['availability'] ?? '',
                'link'        => $offer['url'] ?? '',
            ];
        }
    }

    // ✅ استخراج مشخصات فنی از HTML
    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    libxml_clear_errors();
    $xpath = new DOMXPath($dom);

    $specs = [];

    // مشخصات کلیدی
    $keySpecContainers = $xpath->query("//div[contains(@class,'key-specs-container')]");
    foreach ($keySpecContainers as $container) {
        $labelNode = $xpath->query(".//span", $container);
        $valueNode = $xpath->query(".//div[@dir='auto']", $container);

        $label = $labelNode->length ? trim($labelNode->item(0)->textContent) : '';
        $value = $valueNode->length ? trim($valueNode->item(0)->textContent) : '';

        if ($label && $value) {
            $specs[$label] = $value;
        }
    }

    // مشخصات جزئی‌تر
    $detailTitles = $xpath->query("//div[contains(@class,'detail-title')]");
    foreach ($detailTitles as $titleNode) {
        $valueNode = $xpath->query("../div[contains(@class,'detail-value')]", $titleNode);
        $label = trim($titleNode->textContent);
        $value = ($valueNode->length) ? trim($valueNode->item(0)->textContent) : '';

        if ($label && $value) {
            $specs[$label] = $value;
        }
    }

    $output['specifications'] = $specs;

    echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (\Exception $e) {
    echo json_encode(['error' => 'خطا در دریافت اطلاعات', 'message' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}