<?php
// File: /v2/torob/index.php
declare(strict_types=1);

// -------- Config (اختیاری) --------
const ALLOW_ORIGIN = '*';            // اگر لازم است محدود کنید
const TIMEOUT      = 25;             // ثانیه
const UA           = 'TorobProxy/1.0 (+majazi.top)';
const MAX_SIZE     = 24;             // سقف سایز صفحه در search

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: ' . ALLOW_ORIGIN);
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// پاسخ ساده خطا
function jerr(string $msg, int $code = 400){
  http_response_code($code);
  echo json_encode(['ok'=>false,'error'=>$msg], JSON_UNESCAPED_UNICODE);
  exit;
}

// ورودی‌ها
$fn      = isset($_GET['fn']) ? trim($_GET['fn']) : '';
$api_key = isset($_GET['api_key']) ? trim($_GET['api_key']) : '';

if ($fn === '' || $api_key === '') jerr('fn و api_key الزامی است.');

// ساخت URL مقصد (Torob) بر اساس fn
$target = '';
if ($fn === 'details') {
  $prk = isset($_GET['prk']) ? trim($_GET['prk']) : '';
  if ($prk === '') jerr('پارامتر prk الزامی است.');
  // فقط حروف/اعداد/خط‌تیره را اجازه بدهید
  if (!preg_match('/^[0-9a-fA-F-]{32,36}$/', $prk)) jerr('prk نامعتبر است.');
  $target = 'https://api.torob.com/v4/base-product/details/?source=next_desktop&prk=' . rawurlencode($prk);

} elseif ($fn === 'search') {
  // پارامترهای مجاز
  $allowed = ['category','category_name','brand','brand_name','page','size','sort'];
  $qs = ['source=next_desktop'];
  foreach ($allowed as $k) {
    if (!isset($_GET[$k])) continue;
    $val = is_array($_GET[$k]) ? '' : (string)$_GET[$k];
    if ($val === '') continue;
    // کنترل ساده برای جلوگیری از تزریق
    if (preg_match('/[<>"\'\s]/', $val)) jerr("پارامتر {$k} نامعتبر است.");
    if ($k === 'size') {
      $v = max(1, min((int)$val, MAX_SIZE));
      $qs[] = "size={$v}";
    } else {
      $qs[] = $k . '=' . rawurlencode($val);
    }
  }
  // پیش‌فرض‌ها
  if (!preg_grep('/^size=/', $qs)) $qs[] = 'size=24';
  if (!preg_grep('/^page=/', $qs)) $qs[] = 'page=0';
  if (!preg_grep('/^sort=/', $qs)) $qs[] = 'sort=popularity';

  $target = 'https://api.torob.com/v4/base-product/search/?' . implode('&', $qs);

} else {
  jerr('fn نامعتبر است. (details | search)');
}

// ساخت آدرس ScraperAPI
$proxy = 'https://api.scraperapi.com/?api_key=' . rawurlencode($api_key) . '&url=' . rawurlencode($target);

// فراخوانی با cURL
$ch = curl_init();
curl_setopt_array($ch, [
  CURLOPT_URL            => $proxy,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_MAXREDIRS      => 3,
  CURLOPT_CONNECTTIMEOUT => 10,
  CURLOPT_TIMEOUT        => TIMEOUT,
  CURLOPT_SSL_VERIFYPEER => true,
  CURLOPT_HTTPHEADER     => ['Accept: application/json', 'User-Agent: ' . UA],
]);
$body = curl_exec($ch);
$err  = curl_error($ch);
$code = (int)curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
curl_close($ch);

if ($body === false) jerr('خطای شبکه: ' . $err, 502);
if ($code === 401 || $code === 403) jerr('خطای احراز هویت ScraperAPI (کلید نامعتبر/سهمیه تمام).', 403);
if ($code === 429)                  jerr('محدودیت نرخ ScraperAPI. بعداً دوباره تلاش کنید.', 429);
if ($code < 200 || $code >= 300)    jerr('HTTP ' . $code, 502);

// تایید JSON
$data = json_decode($body, true);
if (json_last_error() !== JSON_ERROR_NONE) {
  // برخی پاسخ‌های ScraperAPI ممکن است HTML بدهند
  jerr('پاسخ نامعتبر (JSON).', 502);
}

// موفق
http_response_code(200);
echo json_encode(['ok'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);