<?php
// irtcishop_category.php — Scrape product names+links from irtcishop.net category pages (PHP 7+)
declare(strict_types=1);
mb_internal_encoding('UTF-8');
header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors','0'); error_reporting(EALL);

try{
  $base = isset($_GET['url']) ? trim($_GET['url']) : '';
  $pages= isset($_GET['pages']) ? (int)$_GET['pages'] : 1;
  if(!$base){ http_response_code(400); echo j(['ok'=>false,'error'=>'missing_url']); exit; }
  if(strpos($base,'http')!==0) $base = 'https://'.$base;
  if($pages<1) $pages = 1;

  // فقط irtcishop.net
  $host = parse_url($base, PHP_URL_HOST) ?: '';
  if(!preg_match('/(^|\.)irtcishop\.net$/i', $host)){
    http_response_code(400); echo j(['ok'=>false,'error'=>'only_irtcishop.net_allowed']); exit;
  }

  // نرمال‌سازی و صفحه‌بندی
  $normBase = ensure_trailing_slash($base);
  [$baseNoPage, $hasPageParam] = strip_page_segment($normBase);

  $items = [];  // url => name
  $debug = [];
  for($p=1; $p <= $pages; $p++){
    $url = $hasPageParam ? preg_replace('#/page/\d+/#','/page/'.$p.'/', $normBase)
                         : add_page_segment($baseNoPage, $p);

    $html = fetch($url);
    if(!$html){ $debug[]=['page'=>$p,'url'=>$url,'error'=>'fetch_failed']; continue; }

    libxml_use_internal_errors(true);
    $dom = new DOMDocument('1.0','UTF-8');
    if(stripos($html,'<meta charset=')===false){ $html = '<meta charset="utf-8">'.$html; }
    $dom->loadHTML($html, LIBXML_NOWARNING|LIBXML_NOERROR);
    libxml_clear_errors();
    $xp = new DOMXPath($dom);

    // ✅ ساختار Flatsome/Woo: div.products.row > div.product-small ...
    // همچنین ul.products > li.product را هم پشتیبانی می‌کنیم
    $q = []
      // لینک استاندارد ووکامرس/فلتسام
      ;$q[] = '//*[contains(@class,"products")]//*[contains(@class,"product")]//a[contains(@class,"woocommerce-LoopProduct-link") or contains(@class,"woocommerce-loop-product__link")]';
      // هر لینکی که به /product/ اشاره کند داخل کارت محصول
      $q[] = '//*[contains(@class,"products")]//*[contains(@class,"product")]//a[contains(@href,"/product/")]';

    $nodes = new ArrayObject();
    foreach ($q as $qq) {
      $nl = $xp->query($qq);
      if($nl && $nl->length){
        foreach($nl as $a){ $nodes->append($a); }
      }
    }

    // استخراج
    $seenOnPage = 0;
    foreach($nodes as $a){
      /** @var DOMElement $a */
      $href = $a->getAttribute('href'); if(!$href) continue;
      // حذف لینک‌های کوییک‌ویو (#quick-view) یا anchorهای داخلی
      if ($href[0]==='#') continue;

      $prodUrl = absurl($href, $url);

      // تلاش برای نام: اول تیترهای رایج داخل کارت
      $name = text($xp, './/h2[contains(@class,"woocommerce-loop-product__title")]|.//*[contains(@class,"product-title")]|.//h3', $a);
      if(!$name){
        // شاید تیتر خارج از همین <a> باشد (Flatsome: <p class="name product-title"><a>...</a>)
        $parent = $a->parentNode;
        if ($parent) {
          $name = text($xp, './/h2[contains(@class,"woocommerce-loop-product__title")]|.//*[contains(@class,"product-title")]|.//h3', $parent);
        }
      }
      if(!$name){
        // بکاپ: متن لینک ولی کوتاه‌شده (ممکنه قیمت/برند هم داخلش باشد)
        $name = trim(preg_replace('/\s+/u',' ', $a->textContent ?? ''));
        if(mb_strlen($name)>160) $name = mb_substr($name,0,160);
      }

      if($prodUrl){
        $seenOnPage++;
        if(!isset($items[$prodUrl])){
          $items[$prodUrl] = $name ?: null;
        } else {
          if(!$items[$prodUrl] && $name) $items[$prodUrl] = $name;
        }
      }
    }

    $debug[] = ['page'=>$p,'url'=>$url,'found'=>$seenOnPage];
  }

  $out = [];
  foreach($items as $u=>$n){ $out[] = ['name'=>$n, 'url'=>$u]; }

  echo j([
    'ok'      => true,
    'url'     => $normBase,
    'pages'   => $pages,
    'count'   => count($out),
    'products'=> $out,
    'debug'   => $debug
  ]);

} catch(Throwable $e){
  http_response_code(500);
  echo j(['ok'=>false,'error'=>'internal_error','msg'=>$e->getMessage()]);
}

/* ===== Helpers ===== */
function j($a){ return json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT); }
function fetch(string $url, int $t=25): ?string{
  if(!function_exists('curl_init')){
    $ctx = stream_context_create(['http'=>['timeout'=>$t,'header'=>"User-Agent:Mozilla/5.0\r\n"]]);
    $b = @file_get_contents($url,false,$ctx); return $b?:null;
  }
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER=>true, CURLOPT_FOLLOWLOCATION=>true, CURLOPT_MAXREDIRS=>5,
    CURLOPT_TIMEOUT=>$t, CURLOPT_CONNECTTIMEOUT=>15,
    CURLOPT_SSL_VERIFYPEER=>true, CURLOPT_SSL_VERIFYHOST=>2,
    CURLOPT_USERAGENT=>'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 Chrome/126 Safari/537.36'
  ]);
  $b = curl_exec($ch); $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE); curl_close($ch);
  return ($b!==false && $code<400) ? $b : null;
}
function ensure_trailing_slash(string $u): string {
  $parts = parse_url($u); if(!$parts) return $u;
  $path = isset($parts['path']) ? $parts['path'] : '/';
  if(substr($path,-1)!=='/') $path.='/';
  $rebuilt = ($parts['scheme']??'https').'://'.$parts['host'].(isset($parts['port'])?':'.$parts['port']:'').$path;
  if(isset($parts['query'])) $rebuilt .= '?'.$parts['query'];
  return $rebuilt;
}
function strip_page_segment(string $u): array {
  $parts = parse_url($u); if(!$parts) return [$u,false];
  $path = $parts['path'] ?? '/';
  if(preg_match('#/page/\d+/#', $path)){
    $base = preg_replace('#/page/\d+/#','/',$u);
    return [ensure_trailing_slash($base), true];
  }
  return [ensure_trailing_slash($u), false];
}
function add_page_segment(string $u, int $p): string {
  if($p<=1) return ensure_trailing_slash($u);
  $parts = parse_url($u); $path = $parts['path'] ?? '/';
  if(substr($path,-1)!=='/') $path.='/';
  $path .= 'page/'.$p.'/';
  $rebuilt = ($parts['scheme']??'https').'://'.$parts['host'].(isset($parts['port'])?':'.$parts['port']:'').$path;
  if(isset($parts['query'])) $rebuilt .= '?'.$parts['query'];
  return $rebuilt;
}
function text(DOMXPath $xp, string $q, DOMNode $ctx=null): ?string{
  $n = $ctx ? $xp->query($q,$ctx)->item(0) : $xp->query($q)->item(0);
  if($n){ $t = trim(preg_replace('/\s+/u',' ',$n->textContent)); return $t!==''?$t:null; }
  return null;
}
function absurl(string $maybe, string $base): string{
  if($maybe==='') return '';
  if(strpos($maybe,'//')===0){ $sch=parse_url($base,PHP_URL_SCHEME)?:'https'; return $sch.':'.$maybe; }
  if(parse_url($maybe, PHP_URL_SCHEME)) return $maybe;
  $p=parse_url($base);
  $root=$p['scheme'].'://'.$p['host'].(isset($p['port'])?':'.$p['port']:'');
  if(strpos($maybe,'/')===0) return $root.$maybe;
  $dir=$root.rtrim(dirname($p['path']??'/'),'/').'/';
  return $dir.$maybe;
}