<?php
// eca_daste.php — لیست محصولات یک دسته از eshop.eca.ir با صفحه‌بندی ?page=N
header('Content-Type: application/json; charset=utf-8');
mb_internal_encoding('UTF-8');

function respond($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT); exit; }

$url  = isset($_GET['url'])   ? trim($_GET['url'])   : '';
$pages= isset($_GET['pages']) ? (int)$_GET['pages']  : 1;
if (!$url){ respond(['ok'=>false,'error'=>'missing_url']); }
if ($pages < 1) $pages = 1;

// اطمینان از حذف اسلش انتهایی
$url = preg_replace('~\/+$~u', '', $url);

// ---- HTTP ----
function http_get($u){
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $u,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS => 5,
        CURLOPT_CONNECTTIMEOUT => 12,
        CURLOPT_TIMEOUT => 25,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_HTTPHEADER => [
            'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
            'Accept-Language: fa-IR,fa;q=0.9,en-US;q=0.8,en;q=0.7',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124 Safari/537.36'
        ],
    ]);
    $body = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    if ($err || $code >= 400 || !$body) return null;
    // نرمال‌سازی کاراکترها
    if (!mb_detect_encoding($body, 'UTF-8', true)){
        $body = mb_convert_encoding($body, 'UTF-8', 'auto');
    }
    return $body;
}

// تبدیل لینک نسبی به مطلق
function abs_url($href, $base){
    if (!$href) return '';
    if (preg_match('~^https?://~i', $href)) return $href;
    // ساخت پایه
    $p = parse_url($base);
    $root = $p['scheme'].'://'.$p['host'];
    if (isset($p['port'])) $root .= ':'.$p['port'];
    if (substr($href,0,1) === '/'){ return $root.$href; }
    // مسیر جاری
    $path = isset($p['path']) ? $p['path'] : '/';
    $dir = preg_replace('~/[^/]*$~','/',$path);
    // نرمال‌سازی ../
    $full = $root.$dir.$href;
    $parts = [];
    foreach (explode('/', $full) as $seg){
        if ($seg === '..'){ array_pop($parts); continue; }
        if ($seg === '.') continue;
        $parts[] = $seg;
    }
    $full = implode('/', $parts);
    // حذف دابل‌اسلش‌ها غیر از پروتکل
    $full = preg_replace('~(?<!:)//+~','/',$full);
    return $full;
}

// استخراج محصولات از HTML (DOM → XPath) + fallback Regex
function extract_products($html, $page_url){
    $items = [];

    // ---- روش ۱: DOM + XPath (ساختار پرستاشاپ ECA) ----
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML('<?xml encoding="UTF-8">' . $html);
    libxml_clear_errors();
    $xp = new DOMXPath($dom);

    // هر کارت محصول
    // ساختار معمول: <article class="product-miniature ..."> ... <a href="..."> ... <h5 class="product-name">نام</h5>
    $articles = $xp->query('//article[contains(@class,"product-miniature")]');
    foreach ($articles as $art){
        $a = $xp->query('.//a[@href]', $art)->item(0);
        $nameNode = $xp->query('.//h5[contains(@class,"product-name")]//span | .//h5[contains(@class,"product-name")]//a | .//h5[contains(@class,"product-name")]', $art)->item(0);

        $href = $a ? trim($a->getAttribute('href')) : '';
        $name = $nameNode ? trim($nameNode->textContent) : '';

        // فیلتر لینک‌های واقعی محصول (الگوی: /{cat}/{id}-{slug}.html)
        if ($href && preg_match('~/(?:\p{L}|-)+/\d+-[^/]+\.html~u', $href)){
            $href = abs_url($href, $page_url);
            if (!$name){
                // اگر نام در h5 نبود، از title/alt/aria-label
                $name = $a->getAttribute('title') ?: $a->textContent;
                $name = trim($name);
            }
            if ($name && $href){
                $items[] = ['name'=>$name,'url'=>$href];
            }
        }
    }

    // ---- روش ۲: fallback Regex (اگر DOM چیزی نداد یا ناقص بود) ----
    if (count($items) === 0){
        // بلاک هر محصول
        if (preg_match_all('~<article[^>]*class="[^"]*product-miniature[^"]*"[^>]*>(.*?)</article>~is', $html, $m)){
            foreach ($m[1] as $blk){
                // لینک محصول
                if (preg_match('~href=["\']([^"\']+\.html)["\']~i', $blk, $lm)){
                    $h = html_entity_decode($lm[1], ENT_QUOTES, 'UTF-8');
                    if (!preg_match('~/(?:\p{L}|-)+/\d+-[^/]+\.html~u', $h)) continue;
                    $h = abs_url($h, $page_url);
                    // نام
                    $n = '';
                    if (preg_match('~<h5[^>]*class="[^"]*product-name[^"]*"[^>]*>.*?(?:<span[^>]*title=["\'](.*?)["\'][^>]*>.*?</span>|<a[^>]*>(.*?)</a>|>([^<]+)<)~isu', $blk, $nm)){
                        $n = $nm[1] ?: $nm[2] ?: $nm[3];
                    }
                    $n = trim(strip_tags(html_entity_decode($n, ENT_QUOTES, 'UTF-8')));
                    if ($n && $h) $items[] = ['name'=>$n,'url'=>$h];
                }
            }
        }
        // اگر باز هم چیزی نبود، آخرین شانس: همه a های .html با الگو
        if (count($items) === 0){
            if (preg_match_all('~<a[^>]+href=["\']([^"\']+\.html)["\'][^>]*>(.*?)</a>~is', $html, $m2, PREG_SET_ORDER)){
                foreach ($m2 as $mm){
                    $h = html_entity_decode($mm[1], ENT_QUOTES, 'UTF-8');
                    if (!preg_match('~/(?:\p{L}|-)+/\d+-[^/]+\.html~u', $h)) continue;
                    $h = abs_url($h, $page_url);
                    $n = trim(strip_tags(html_entity_decode($mm[2], ENT_QUOTES, 'UTF-8')));
                    if ($n && $h) $items[] = ['name'=>$n,'url'=>$h];
                }
            }
        }
    }

    // حذف تکراری‌ها با کلید URL
    $uniq = [];
    $out = [];
    foreach ($items as $it){
        $k = $it['url'];
        if (!isset($uniq[$k])){ $uniq[$k]=1; $out[]=$it; }
    }
    return $out;
}

// ---- Run ----
$all = [];
$debug = [];
for ($p=1; $p <= $pages; $p++){
    $page_url = $url . ($p>1 ? ('?page='.$p) : '');
    $html = http_get($page_url);
    if ($html === null){
        $debug[] = ['page'=>$p,'url'=>$page_url,'found'=>0,'error'=>'http_failed'];
        continue;
    }
    $items = extract_products($html, $page_url);
    $debug[] = ['page'=>$p,'url'=>$page_url,'found'=>count($items)];
    $all = array_merge($all, $items);
}
// نهایی: دوباره یکتا
$uniq = [];
$out = [];
foreach ($all as $it){ if (empty($uniq[$it['url']])){ $uniq[$it['url']]=1; $out[]=$it; } }

respond([
    'ok'      => true,
    'url'     => $url . '/',
    'pages'   => $pages,
    'count'   => count($out),
    'products'=> $out,
    'debug'   => $debug
]);
