<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL); ini_set('display_errors','0'); set_time_limit(90);

function respond($status, array $payload){ http_response_code($status); echo json_encode($payload, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT); exit; }

function httpGet($url,$timeout=25){
  $ch=curl_init($url);
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true, CURLOPT_FOLLOWLOCATION=>true, CURLOPT_MAXREDIRS=>5,
    CURLOPT_CONNECTTIMEOUT=>12, CURLOPT_TIMEOUT=>$timeout,
    CURLOPT_USERAGENT=>'Mozilla/5.0 (compatible; ProductScraper/1.1)',
    CURLOPT_HTTPHEADER=>['Accept:text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8','Accept-Language: fa,en;q=0.9'],
    CURLOPT_ENCODING=>''
  ]);
  $body=curl_exec($ch); $err=curl_error($ch); $code=(int)curl_getinfo($ch,CURLINFO_HTTP_CODE); curl_close($ch);
  return [$code,$body,$err];
}

function withPage($baseUrl,$pageNum,$param='page'){
  $parts=parse_url($baseUrl); $query=[]; if(isset($parts['query'])) parse_str($parts['query'],$query);
  $query[$param]=$pageNum; $parts['query']=http_build_query($query);
  return (isset($parts['scheme'])?$parts['scheme'].'://':'').($parts['host']??'').(isset($parts['port'])?':'.$parts['port']:'')
       .($parts['path']??'').(!empty($parts['query'])?('?'.$parts['query']):'').(isset($parts['fragment'])?('#'.$parts['fragment']):'');
}

function startsWith($h,$n){ return $n==='' || strncmp($h,$n,strlen($n))===0; }

function absolutize($href,$base){
  if(preg_match('#^https?://#i',$href)) return $href;
  $b=parse_url($base); if(!$b||empty($b['scheme'])||empty($b['host'])) return $href;
  $scheme=$b['scheme']; $host=$b['host']; $port=isset($b['port'])?':'.$b['port']:''; $basePath=$b['path']??'/';
  if(startsWith($href,'/')) return "{$scheme}://{$host}{$port}{$href}";
  $dir=rtrim(str_replace('\\','/',dirname($basePath)),'/'); $path=($dir===''?'/'.$href:$dir.'/'.$href);
  $segments=[]; foreach(explode('/',$path) as $seg){ if($seg===''||$seg=='.') continue; if($seg==='..'){ array_pop($segments); continue; } $segments[]=$seg; }
  return "{$scheme}://{$host}{$port}/".implode('/',$segments);
}

function parseProducts($html,$baseUrl,&$notes){
  $dom=new DOMDocument(); @$dom->loadHTML($html, LIBXML_NOWARNING|LIBXML_NOERROR);
  $xp=new DOMXPath($dom);

  // --- سلکتورهای اختصاصی ghabnaab ---
  // 1) نام محصول: div.pro-name > a
  // 2) لینک تصویر محصول: a.img-pro (fallback اگر نام داخل pro-name نیامده باشد)
  $xpaths = [
    "//div[contains(@class,'pro-name')]//a[@href and normalize-space(string())!='']",
    "//a[contains(@class,'img-pro')][@href and @target='_blank']"
  ];

  $found = [];
  foreach($xpaths as $q){
    $nodes=$xp->query($q); if(!$nodes) continue;
    foreach($nodes as $a){
      $name=trim(preg_replace('/\s+/',' ',$a->textContent));
      $href=$a->getAttribute('href'); if($href==='') continue;
      $abs=absolutize($href,$baseUrl);

      // فیلتر: لینک‌های داخلی لیست محصول (روی این سایت مثل /R-883 هستند)
      if(!preg_match('#^https?://(www\.)?ghabnaab\.com/#i',$abs)) continue;

      // اگر اسم خالی بود (مثلاً img-pro)، بعداً از pro-name برای همان URL پر می‌کنیم
      if($name===''){ $name=null; }

      // فقط لینک‌های مربوط به آیتم محصول (نه دسته‌بندی/منو)
      // روی این سایت الگوی R-*** رایج است؛ اما اجازه می‌دهیم دیگر آیتم‌های جزئیات هم بمانند.
      if(preg_match('#/(Apple-Accessories|Samsung-case|xiaomi-case|CUSTOM-CASE|iqos|case)(/|\\?|$)#i',$abs)) continue;

      // ددیوپ بر اساس URL: اگر قبلاً همین URL را داشتیم و نام جدید موجود است، جایگزین کن
      if(!isset($found[$abs]) || ($found[$abs]===null && $name!==null)){
        $found[$abs]=$name;
      }
    }
  }

  if(empty($found)){ $notes[]=['type'=>'parse_notice','message'=>'No products found under .pro-name or a.img-pro']; }

  // اگر بعضی nameها خالی ماندند، تلاش برای استخراج نام از alt تصویرِ نزدیک:
  if(!empty($found)){
    foreach($found as $u=>$n){
      if($n!==null) continue;
      // تلاش: <a class="img-pro"><img alt="نام..." /></a>
      $query=sprintf("//a[@href='%s']//img[@alt]", htmlspecialchars($u, ENT_QUOTES));
      $nodes=$xp->query($query);
      if($nodes && $nodes->length>0){
        $alt=trim($nodes->item(0)->getAttribute('alt'));
        if($alt!=='') $found[$u]=$alt;
      }
    }
  }

  $out=[]; foreach($found as $url=>$name){ $out[]=['name'=>$name??'', 'url'=>$url]; }
  return $out;
}

/* -------- Input -------- */
$baseUrl = isset($_GET['url']) ? trim($_GET['url']) : '';
$pages   = isset($_GET['pages']) ? (int)$_GET['pages'] : 1;
if($baseUrl==='') respond(400,['error'=>'Missing required parameter: url']);
if(!filter_var($baseUrl, FILTER_VALIDATE_URL)) respond(400,['error'=>'Invalid URL']);
if($pages<1) $pages=1; $pages=min($pages,100);

$all=[]; $errors=[]; $notes=[];
for($p=1;$p<=$pages;$p++){
  $pageUrl = withPage($baseUrl,$p,'page');
  if($p>1) usleep(250000);
  list($code,$body,$err)=httpGet($pageUrl);
  if($err||$code>=400||!$body){ $errors[]=['page'=>$p,'url'=>$pageUrl,'http_status'=>$code,'error'=>$err?:'HTTP error or empty body']; continue; }
  $items = parseProducts($body,$pageUrl,$notes);
  if(empty($items)){ $errors[]=['page'=>$p,'url'=>$pageUrl,'warning'=>'No products detected on this page']; }
  foreach($items as $it){ $all[$it['url']] = $it['name']; }
}

$resp=['source'=>$baseUrl,'pages_requested'=>$pages,'count'=>count($all),'products'=>[]];
foreach($all as $u=>$n){ $resp['products'][]=['name'=>$n,'url'=>$u]; }
if(!empty($errors)) $resp['errors']=$errors;
if(!empty($notes))  $resp['debug_errors']=$notes;

respond(200,$resp);